from bottle import Bottle, request, response
import shelve
import random


SUBMISSION_FORM = """
<h1>Link Shortener</h1>
<form>
    <label>URL</label>
    <input name="url" type="url">
    <input type="submit">
</form>
"""
SUCCESS_MESSAGE = """
<span>Successful submission! Your link is <a href="/{path}">{path}</a>.</span>
"""

app = Bottle()
links = shelve.open("link_shortener.shelve")

@app.get("/")
def index():
    url = request.query.get("url")
    if url:
        path = random.randbytes(3).hex()
        while path in links:
            path = random.randbytes(3).hex()
        links[path] = url
        return SUCCESS_MESSAGE.format(path=path)
    else:
        return SUBMISSION_FORM

@app.get("/<path>")
def follow_link(path):
    link = links.get(path)
    if link:
        response.status = 302
        response.set_header("Location", link)
        return "Redirecting..."
    else:
        response.status = 404
        return "Not found"

try:
    app.run()
finally:
    links.close()
