# this example requires `ffmpeg` to be installed and available on the path!

from io import BytesIO
import subprocess
from bottle import Bottle, request, response
import mimetypes


def list_formats():
    res = subprocess.run(["ffmpeg", "-formats"], capture_output=True)
    lines = res.stdout.decode().split("\n")
    start = lines.index(" ---") + 1
    stop = -1
    lines = lines[start:stop]
    formats = [(line[1:4], line[5:21].strip(), line[21:]) for line in lines]
    return sorted(formats, key=lambda format: format[1])

def format_options(formats):
    result = []
    for format in formats:
        result.append(f'<option value="{format[1]}">{format[1]}</option>')
    return "".join(result)

FORMATS = list_formats()
INTERFACE = f"""
<h1>Audio-Video Converter</h1>
<form method="POST" action="/convert" enctype="multipart/form-data">
    <label>File</label>
    <input name="file" type="file">
    <label>Output Format</label>
    <select name="fmt">{format_options(FORMATS)}</select>
    <input type="submit">
</form>
"""

app = Bottle()

@app.get("/")
def index():
    return INTERFACE

@app.post("/convert")
def convert():
    file = request.files.get("file")
    fmt = request.forms.get("fmt")
    io = BytesIO()
    file.save(io)
    res = subprocess.run(["ffmpeg", "-i", "pipe:", "-f", fmt, "pipe:"], input=io.getvalue(), capture_output=True)
    filename = f"media.{fmt}"
    response.set_header("Content-Disposition", f'attachment; filename="{filename}"')
    response.content_type = mimetypes.guess_type(filename)[0] or "application/octet-stream"
    return res.stdout

app.run()
